'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================


Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
On Error GoTo Err_Form_Open

    Dim x, a, b, c, d As Integer
    Dim olkAnw, meinNamespace As Object
    Dim myNode, myFolder, myFolder0, myFolder1, myFolder2, myFolder3 As Object
    Dim IconName As String
    Dim PapierkorbID As String
    Dim PosteingangID As String
    Dim PostausgangID As String
    Dim GesendetID As String
    Dim EntwurfID As String
    Dim JournalID As String
    Dim OrdnerAnzahl As Long
    
    
    Set olkAnw = CreateObject("outlook.application")
    Set meinNamespace = olkAnw.GetNamespace("MAPI")
    
    'Name des Papierkorbes ermitteln, fr Extrasymbol
    '   olFolderDeletedItems    =  3
    '   olFolderOutbox          =  4
    '   olFolderSentMail        =  5
    '   olFolderInbox           =  6
    '   olFolderCalendar        =  9
    '   olFolderContacts        = 10
    '   olFolderJournal         = 11
    '   olFolderNotes           = 12
    '   olFolderTasks           = 13
    '   olFolderDrafts          = 16
    Set myFolder = meinNamespace.GetDefaultFolder(3)
    PapierkorbID = myFolder.EntryID
    Set myFolder = meinNamespace.GetDefaultFolder(4)
    PostausgangID = myFolder.EntryID
    Set myFolder = meinNamespace.GetDefaultFolder(5)
    GesendetID = myFolder.EntryID
    Set myFolder = meinNamespace.GetDefaultFolder(6)
    PosteingangID = myFolder.EntryID
    Set myFolder = meinNamespace.GetDefaultFolder(16)
    EntwurfID = myFolder.EntryID
    
    
    
    '================================================================================
    'nchste Zeile nur fr Testzwecke aktivieren
    'OutlookOrdner_Art = "Termine"                       ' "Termine" oder "Kontakte"
    '================================================================================
    
    
    'Beschriftungen anpassen
    If OutlookOrdner_Art = "Termine" Then
        Me.Bezeichner_Ueberschrift.Caption = "Bitte whlen Sie den Kalender-Ordner in der Liste aus:"
'        Me.Bezeichner_Postfach.Caption = "Termine - Kontainer:"
'        Me.Bezeichner_Ordner1.Caption = "Termine - Unterordner 1:"
'        Me.Bezeichner_Ordner2.Caption = "Termine - Unterordner 2:"
'        Me.Bezeichner_Ordner3.Caption = "Termine - Unterordner 3:"
    Else
        Me.Bezeichner_Ueberschrift.Caption = "Bitte whlen Sie den Kontakte-Ordner in der Liste aus:"
'        Me.Bezeichner_Postfach.Caption = "Kontakte - Kontainer:"
'        Me.Bezeichner_Ordner1.Caption = "Kontakte - Unterordner 1:"
'        Me.Bezeichner_Ordner2.Caption = "Kontakte - Unterordner 2:"
'        Me.Bezeichner_Ordner3.Caption = "Kontakte - Unterordner 3:"
    End If
    
    x = 1
    
    ' "spezielle" Fehlerbehandlung (fr MSCOMCTL.OCX) einschalten, die dann ausgelst wird, wenn
    ' das TreeView in der nchsten Zeile mit einem Fehler reagiert
    On Error GoTo Err_TreeView
    Me.TreeView_OutlookOrdner.Sorted = False
    
    ' "normale" Fehlerbehandlung wieder einschalten
    On Error GoTo Err_Form_Open
    
    
    'Baum"wurzel" anlegen
    Me.TreeView_OutlookOrdner.Nodes.Add , , , "Outlook"
    '1. Ebene unterhalb "Outlook" soll ausgeklappt sein
    Set myNode = Me.TreeView_OutlookOrdner.Nodes.Item(1)
    myNode.Expanded = True
    myNode.Image = "IconOutlook"
    myNode.ExpandedImage = "IconOutlook"
    myNode.SelectedImage = "IconOutlook"
    
    'Einlesen der Ordnerstruktur von Outlook
    a = x
    For Each myFolder0 In meinNamespace.Folders             'Postfcher
        Set myNode = Me.TreeView_OutlookOrdner.Nodes.Add(a, 4, , myFolder0.Name)    ' 4 = tvwChild
        myNode.Image = "IconOutlookHeute"
        myNode.ExpandedImage = "IconOutlookHeute"
        myNode.SelectedImage = "IconOutlookHeute"
        x = x + 1
        b = x
        'Test+Fehlerbehandlung, ob Unterodner lesbar sind (fr Kontainer mit Kennwortschutz oder Fehler)
        On Error GoTo Err_NichtLesbar_1
        OrdnerAnzahl = 0
        OrdnerAnzahl = myFolder0.Folders.Count
        On Error GoTo Err_Form_Open
        If OrdnerAnzahl > 0 Then
            For Each myFolder1 In myFolder0.Folders             '1.Unterordner
                Set myNode = Me.TreeView_OutlookOrdner.Nodes.Add(b, 4, , myFolder1.Name)    ' 4 = tvwChild
                'IDs des Ordners merken
                myNode.Key = myFolder1.EntryID & "__XYZ__" & myFolder1.StoreID
                'Ausnahme: Unterordner = Papierkorb, Posteingang, -ausgang, -gesendet, Entwuerfe?
                Select Case myFolder1.EntryID
                    Case PapierkorbID
                        myNode.Image = "IconPapierkorb"
                        myNode.ExpandedImage = "IconPapierkorb"
                        myNode.SelectedImage = "IconPapierkorb"
                    Case PostausgangID
                        myNode.Image = "IconPostausgang"
                        myNode.ExpandedImage = "IconPostausgang"
                        myNode.SelectedImage = "IconPostausgang"
                    Case PosteingangID
                        myNode.Image = "IconPosteingang"
                        myNode.ExpandedImage = "IconPosteingang"
                        myNode.SelectedImage = "IconPosteingang"
                    Case GesendetID
                        myNode.Image = "IconGesendet"
                        myNode.ExpandedImage = "IconGesendet"
                        myNode.SelectedImage = "IconGesendet"
                    Case EntwurfID
                        myNode.Image = "IconEntwurf"
                        myNode.ExpandedImage = "IconEntwurf"
                        myNode.SelectedImage = "IconEntwurf"
                    Case Else
                        OrdnerSymbol myFolder1, myNode
                End Select
                x = x + 1
                c = x
                'Test+Fehlerbehandlung, ob Unterodner lesbar sind (fr Kontainer mit Kennwortschutz oder Fehler)
                On Error GoTo Err_NichtLesbar_2
                OrdnerAnzahl = 0
                OrdnerAnzahl = myFolder1.Folders.Count
                On Error GoTo Err_Form_Open
                If OrdnerAnzahl > 0 Then
                    For Each myFolder2 In myFolder1.Folders         '2.Unterordner
                        Set myNode = Me.TreeView_OutlookOrdner.Nodes.Add(c, 4, , myFolder2.Name)    ' 4 = tvwChild
                        myNode.Key = myFolder2.EntryID & "__XYZ__" & myFolder2.StoreID
                        OrdnerSymbol myFolder2, myNode
                        x = x + 1
                        d = x
                        On Error GoTo Err_NichtLesbar_3
                        OrdnerAnzahl = 0
                        OrdnerAnzahl = myFolder2.Folders.Count
                        On Error GoTo Err_Form_Open
                        If OrdnerAnzahl > 0 Then
                            For Each myFolder3 In myFolder2.Folders     '3.Unterordner
                                Set myNode = Me.TreeView_OutlookOrdner.Nodes.Add(d, 4, , myFolder3.Name)    ' 4 = tvwChild
                                myNode.Key = myFolder3.EntryID & "__XYZ__" & myFolder3.StoreID
                                OrdnerSymbol myFolder3, myNode
                                x = x + 1
                            Next myFolder3
                        End If
                        GoTo Nach_Err_NichtLesbar_3     'im Normallauf die Fehlerbehandlung berspringen
Err_NichtLesbar_3:
                        Resume Behandlung_Err_NichtLesbar_3
Behandlung_Err_NichtLesbar_3:
                        myNode.Text = myNode.Text & " <nicht lesbar>"
Nach_Err_NichtLesbar_3:
                    Next myFolder2
                End If
                GoTo Nach_Err_NichtLesbar_2     'im Normallauf die Fehlerbehandlung berspringen
Err_NichtLesbar_2:
                Resume Behandlung_Err_NichtLesbar_2
Behandlung_Err_NichtLesbar_2:
                myNode.Text = myNode.Text & " <nicht lesbar>"
Nach_Err_NichtLesbar_2:
            Next myFolder1
        End If
        GoTo Nach_Err_NichtLesbar_1     'im Normallauf die Fehlerbehandlung berspringen
Err_NichtLesbar_1:
        Resume Behandlung_Err_NichtLesbar_1
Behandlung_Err_NichtLesbar_1:
        myNode.Text = myNode.Text & " <nicht lesbar>"
Nach_Err_NichtLesbar_1:
    Next myFolder0
    
    'Fals nur 1 Postfach existiert, dieses aufklappen
    Set myNode = Me.TreeView_OutlookOrdner.Nodes.Item(1)
    If myNode.Children = 1 Then
        Set myNode = myNode.Child
        myNode.Expanded = True
    End If
    
    'Sortierung wieder einschalten
    Me.TreeView_OutlookOrdner.Sorted = True
    Me.TreeView_OutlookOrdner.Refresh
    

Exit_Form_Open:
    Exit Sub

Err_Form_Open:
    MsgBox "Auf der Maske ist ein Fehler aufgetreten.", vbCritical + vbOKOnly, "Fehler"
    MsgBox err.Description
    Resume Exit_Form_Open

Err_TreeView:
    MsgBox "Die Anzeige der Baumstruktur auf der zu ffnenden Maske konnte nicht initialisiert werden." & _
        vbNewLine & vbNewLine & "Bitte prfen Sie, ob die Microsoft-Datei MSCOMCTL.OCX " & _
        "(in der richtigen Version) installiert und im System registiert ist. " & _
        "Eine Anleitung zur Installation finden Sie im Handbuch zur Terminabrechnung.", vbCritical + vbOKOnly, "Fehler"
    FehlerFormularOeffnen = True
    'MsgBox Err.Description
    Resume Exit_Form_Open
    
End Sub

Private Sub OrdnerSymbol(OutlookOrdner, Baumknoten)
    Dim IconText As String
    
    '0 = olMailItem
    '1 = olAppointmentItem
    '2 = olContactItem
    '3 = olTaskItem
    '4 = olJournalItem
    '5 = olNoteItem
    '6 = olPostItem
    '7 = olDistibutionsListItem
    IconText = "IconOrdner"

    If OutlookOrdner.DefaultItemType = 0 Then
        IconText = "IconMail"
    ElseIf OutlookOrdner.DefaultItemType = 1 Then
        IconText = "IconTermin"
    ElseIf OutlookOrdner.DefaultItemType = 2 Then
        IconText = "IconKontakt"
    ElseIf OutlookOrdner.DefaultItemType = 3 Then
        IconText = "IconAufgabe"
    ElseIf OutlookOrdner.DefaultItemType = 4 Then
        IconText = "IconJournal"
    ElseIf OutlookOrdner.DefaultItemType = 5 Then
        IconText = "IconNotiz"
    ElseIf OutlookOrdner.DefaultItemType = 6 Then
        IconText = "IconOrdner"
    ElseIf OutlookOrdner.DefaultItemType = 7 Then
        IconText = "IconVerteiler"
    Else
        IconText = "IconOrdner"
    End If
    
    Baumknoten.Image = IconText
    Baumknoten.ExpandedImage = IconText
    Baumknoten.SelectedImage = IconText
    
End Sub

Private Sub Form_Timer()
    'regelmig den ausgewlten Pfad zergliedern und anzeigen
    TreeView_OutlookOrdner_Click
End Sub

Private Sub Start_Click()
'On Error GoTo Err_Start_Click
    Dim myNode As Object
    
    Dim dbs As Database, rst As Recordset
    Dim FilterKalender As String
    Dim Fehlertext As String
    
    Dim Ordner_Key As String
    Dim Ordner_EntryID As String
    Dim Ordner_StoreID As String
    Dim Ordner_Pfad As String
    Dim Ordner_Trennzeichen As String
    
    Dim Ordner_lfd_Nr As Long
    
    
    'Leeres Bezeichnungsfeld abfangen
    If (IsNull(Me.Bezeichnung.Value) Or (Trim(Me.Bezeichnung.Value) = "")) Then
        MsgBox "Bitte geben Sie eine Bezeichnung fr den Kalender ein.", vbCritical, "Fehler"
        Me.Bezeichnung.SetFocus
        Exit Sub
    End If
    
    'Prfen, ob die Art des gewlten Ordners zur gesuchten Art passt
    Set myNode = Me.TreeView_OutlookOrdner.SelectedItem
    If OutlookOrdner_Art = "Termine" Then
        If myNode.Image <> "IconTermin" Then
            'Folgende Abfrage deaktiviert, da beim Einlesen von Terminen von einem Nicht-Termin-Ordner
            ' ein Fehler entsteht
            'If MsgBox("Der gewhlte Ordner ist nicht vom Typ 'Terminordner'." & vbNewLine & _
            '    "Trotzdem bernehmen?", vbExclamation + vbYesNo + vbDefaultButton2, "Achtung") = vbNo Then Exit Sub
            MsgBox "Der gewhlte Ordner ist nicht vom Typ 'Terminordner'!", vbCritical, "Fehler"
            Exit Sub
        End If
    Else
        If myNode.Image <> "IconKontakt" Then
            'Folgende Abfrage deaktiviert, da beim Einlesen von Terminen von einem Nicht-Termin-Ordner
            ' ein Fehler entsteht
            'If MsgBox("Der gewhlte Ordner ist nicht vom Typ 'Kontaktordner'." & vbNewLine & _
            '    "Trotzdem bernehmen?", vbExclamation + vbYesNo + vbDefaultButton2, "Achtung") = vbNo Then Exit Sub
            MsgBox "Der gewhlte Ordner ist nicht vom Typ 'Kontaktordner'!", vbCritical, "Fehler"
            Exit Sub
        End If
    End If
    
    
    'Versuchen Outlook zu ffnen --------------------------------
    Set olkAnw = CreateObject("outlook.application")
    Set meinNamespace = olkAnw.GetNamespace("MAPI")
    
    
    'Ordnerauswahl speichern------------------------------------------
    
    'Fehlerbehandlung abschalten, da die Zeile danach (.SelectedItem) beim Initialisieren
    '   der Maske in Access-97 beim ersten Aufruf einen Fehler erzeugt.
    '   Bei Aufrufen danach nicht mehr. Warum auch immer.?
    ''On Error Resume Next
    '   Diese Zeile verursacht den Fehler:
    Ordner_Pfad = Me.TreeView_OutlookOrdner.SelectedItem.FullPath
    
    Ordner_Key = Me.TreeView_OutlookOrdner.SelectedItem.Key
    Ordner_EntryID = Left(Ordner_Key, InStr(1, Ordner_Key, "__XYZ__") - 1)
    Ordner_StoreID = Mid(Ordner_Key, InStr(1, Ordner_Key, "__XYZ__") + 7)
    Ordner_Trennzeichen = Me.TreeView_OutlookOrdner.PathSeparator
    
    'Das cryptische Trennzeichen in ein "\" umwandeln
    '  Damit wird der Pfad zwar fr spter unbrauchbar, da auch in der Bezeichnung "\" enthalten sein kann,
    '  wird aber derzeit auch nicht bentigt
    Do While InStr(1, Ordner_Pfad, Ordner_Trennzeichen) > 0
        Ordner_Pfad = Left(Ordner_Pfad, InStr(1, Ordner_Pfad, Ordner_Trennzeichen) - 1) & "\" & Mid(Ordner_Pfad, InStr(1, Ordner_Pfad, Ordner_Trennzeichen) + 1)
    Loop
    
    'Filterzeichenkette vorbereiten
    FilterKalender = "SELECT * FROM Kalender WHERE [Kalender_ID] = '" & Ordner_EntryID & "'"
    
    Set dbs = CurrentDb
    
    'Tabelle ffnen und nachsehen, ob Kalender-Ordner bereis vorhanden ist
    Set rst = dbs.OpenRecordset(FilterKalender)
    '1.) auf EntryID des Ordners prfen...
    If (rst.RecordCount) = 0 Then
        'wenn bereits die EntryID nicht vorhanden ist,
        'dann Ordner anlegen
        rst.AddNew
        rst!Aktiv = True
        rst!Name = Left(Trim(Me.Bezeichnung.Value), 50)
        rst!Kalender_ID = Ordner_EntryID
        rst!Store_ID = Ordner_StoreID
        rst!Pfad = Ordner_Pfad
        rst!Trennzeichen = Ordner_Trennzeichen      'noch nicht bentigt
        rst.Update
            'Nummer merken fr spter
            rst.Bookmark = rst.LastModified
            Ordner_lfd_Nr = rst!lfd_Nr
        rst.Close
    Else
        If rst!Store_ID = Ordner_StoreID Then
            '2.) wenn EntryID bereits vorhanden ist, auf StoreID des Ordners prfen...
            'wenn Ordner bereits vorhanden
            Fehlertext = " Der Kalender ist bereits unter der Bezeichnung [" & rst!Name & "] vorhanden."
            Fehlertext = Fehlertext & vbNewLine & " Pfad: " & rst!Pfad
            MsgBox Fehlertext, vbCritical, "Fehler"
            rst.Close
            Exit Sub
        Else
            'wenn bei zwar gleicher EntryID aber die StoreID anders ist,
            'dann Kalender anlegen
            rst.AddNew
            rst!Aktiv = True
            rst!Name = Left(Trim(Me.Bezeichnung.Value), 50)
            rst!Kalender_ID = Ordner_EntryID
            rst!Store_ID = Ordner_StoreID
            rst!Pfad = Left(Ordner_Pfad, 50)
            rst!Trennzeichen = Ordner_Trennzeichen      'noch nicht bentigt
            rst.Update
                'Nummer merken fr spter
                rst.Bookmark = rst.LastModified
                Ordner_lfd_Nr = rst!lfd_Nr
            rst.Close
        End If
    End If
    Set rst = Nothing
    
    
    'Termine, noch ohne Kalenderbezug, auf hinzugefgten Ordner prfen
    TerminzuordnungZuKalenderPruefen Ordner_lfd_Nr, Ordner_EntryID, Ordner_StoreID
            
    
    Set dbs = Nothing
    
    'Fehlerbehandlung wieder umschalten!
    On Error Resume Next
    
    'Anzeige aktualisieren
    Forms![Einstellungen_2].[Kalenderauswahl].Form.Requery
    
    'sich selbst schlieen
    DoCmd.Close acForm, "Outlook_Ordnerliste", acSaveYes
    
    
    
    'Ordnerauswahl in die Einstellungen bernehmen--------------------
    
''    If OutlookOrdner_Art = "Termine" Then
''        Forms![Einstellungen_2].Terminordner_Postfach = Me.Text_Postfach.Caption
''        Forms![Einstellungen_2].Terminordner_Ebene1 = Me.Text_Ordner1.Caption
''        'Leere Ebenen 2 und 3 abfangen
''        If Me.Text_Ordner2.Caption = "" Then
''            Forms![Einstellungen_2].Terminordner_Ebene2 = Null
''        Else
''            Forms![Einstellungen_2].Terminordner_Ebene2 = Me.Text_Ordner2.Caption
''        End If
''        If Me.Text_Ordner3.Caption = "" Then
''            Forms![Einstellungen_2].Terminordner_Ebene3 = Null
''        Else
''            Forms![Einstellungen_2].Terminordner_Ebene3 = Me.Text_Ordner3.Caption
''        End If
''    Else
''        Forms![Einstellungen_2].Kontaktordner_Postfach = Me.Text_Postfach.Caption
''        Forms![Einstellungen_2].Kontaktordner_Ebene1 = Me.Text_Ordner1.Caption
''        'Leere Ebenen 2 und 3 abfangen
''        If Me.Text_Ordner2.Caption = "" Then
''            Forms![Einstellungen_2].Kontaktordner_Ebene2 = Null
''        Else
''            Forms![Einstellungen_2].Kontaktordner_Ebene2 = Me.Text_Ordner2.Caption
''        End If
''        If Me.Text_Ordner3.Caption = "" Then
''            Forms![Einstellungen_2].Kontaktordner_Ebene3 = Null
''        Else
''            Forms![Einstellungen_2].Kontaktordner_Ebene3 = Me.Text_Ordner3.Caption
''        End If
''    End If
''
''    'Ordnerauswahl schlieen
''    DoCmd.Close


Exit_Start_Click:
    Exit Sub

Err_Start_Click:
    MsgBox err.Description
    Resume Exit_Start_Click
    
End Sub

Private Sub TreeView_OutlookOrdner_Click()
    Dim Position As Integer
    Dim Pfad As String, Trennzeichen As String
    
    Dim O1 As String
    Dim O2 As String
    Dim O3 As String
    
'    Dim myNode As Object
'    Set myNode = Me.TreeView_OutlookOrdner.Node
'    Pfad = myNode.FullPath

    'Fehlerbehandlung abschalten, da die Zeile danach (.SelectedItem) beim Initialisieren
    '   der Maske in Access-97 beim ersten Aufruf einen Fehler erzeugt.
    '   Bei Aufrufen danach nicht mehr. Warum auch immer.?
    On Error Resume Next
    '   Diese Zeile verursacht den Fehler:
    Pfad = Me.TreeView_OutlookOrdner.SelectedItem.FullPath
    
    
    Trennzeichen = Me.TreeView_OutlookOrdner.PathSeparator
    
    'Anzeigewerte merken
    O1 = Me.Text_Ordner1.Caption
    O2 = Me.Text_Ordner2.Caption
    O3 = Me.Text_Ordner3.Caption
    
    'Anzeige leeren
    Me.Text_Postfach.Caption = ""
    Me.Text_Ordner1.Caption = ""
    Me.Text_Ordner2.Caption = ""
    Me.Text_Ordner3.Caption = ""
    'Me.Bezeichnung.Value = ""  <-- nicht leeren!
    
    'Aufdrseln des Pfades in die einzelnen Ordner
    ' -> die Bezeichnung wird nur aktualisiert, wenn der Ordner gewechselt wurde,
    '    ansonsten soll die eigene Eingabe in dem Feld stehen bleiben!
    
    'Wurzel/Prfix ("Outlook") entfernen
    Position = InStr(Pfad, Trennzeichen)
    If Position < 1 Then
        Me.Start.Enabled = False
        Exit Sub
    End If
    Pfad = Mid(Pfad, Position + 1)          'Pfad ohne Prfix
    If Len(Pfad) < 1 Then
        Me.Start.Enabled = False
        Exit Sub
    End If
    
    'Postfach ermitteln
    Position = InStr(Pfad, Trennzeichen)
    If Position < 1 Then
        Me.Text_Postfach.Caption = Pfad
        Me.Start.Enabled = False
        Exit Sub
    Else
        Me.Text_Postfach.Caption = Mid(Pfad, 1, Position - 1)
        Pfad = Mid(Pfad, Position + 1)          'Pfad ohne Postfach
        If Len(Pfad) < 1 Then
            Me.Start.Enabled = False
            Exit Sub
        End If
    End If
    
    '1.Unterordner ermitteln
    Me.Start.Enabled = True
    Position = InStr(Pfad, Trennzeichen)
    If Position < 1 Then
        Me.Text_Ordner1.Caption = Pfad
        If Me.Text_Ordner1.Caption <> O1 Then Me.Bezeichnung.Value = Me.Text_Ordner1.Caption
        Exit Sub
    Else
        Me.Text_Ordner1.Caption = Mid(Pfad, 1, Position - 1)
        If Me.Text_Ordner1.Caption <> O1 Then Me.Bezeichnung.Value = Me.Text_Ordner1.Caption
        Pfad = Mid(Pfad, Position + 1)          'Pfad ohne 1.Unterordner
        If Len(Pfad) < 1 Then Exit Sub
    End If
    
    '2.Unterordner ermitteln
    Me.Start.Enabled = True
    Position = InStr(Pfad, Trennzeichen)
    If Position < 1 Then
        Me.Text_Ordner2.Caption = Pfad
        If Me.Text_Ordner2.Caption <> O2 Then Me.Bezeichnung.Value = Me.Text_Ordner2.Caption
        Exit Sub
    Else
        Me.Text_Ordner2.Caption = Mid(Pfad, 1, Position - 1)
        If Me.Text_Ordner2.Caption <> O2 Then Me.Bezeichnung.Value = Me.Text_Ordner2.Caption
        Pfad = Mid(Pfad, Position + 1)          'Pfad ohne 2.Unterordner
        If Len(Pfad) < 1 Then Exit Sub
    End If
    
    '3.Unterordner ermitteln
    Me.Start.Enabled = True
    Position = InStr(Pfad, Trennzeichen)
    If Position < 1 Then
        Me.Text_Ordner3.Caption = Pfad
        If Me.Text_Ordner3.Caption <> O2 Then Me.Bezeichnung.Value = Me.Text_Ordner3.Caption
        Exit Sub
    Else
        Me.Text_Ordner3.Caption = Mid(Pfad, 1, Position - 1)
        If Me.Text_Ordner3.Caption <> O2 Then Me.Bezeichnung.Value = Me.Text_Ordner3.Caption
        Pfad = Mid(Pfad, Position + 1)          'Pfad ohne 3.Unterordner  ;-)
        If Len(Pfad) < 1 Then Exit Sub
    End If
    
End Sub

Private Sub TreeView_OutlookOrdner_LostFocus()
    TreeView_OutlookOrdner_Click
End Sub

